/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.managers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.recipes.CTRecipeShaped;
import com.blamejared.crafttweaker.impl.recipes.CTRecipeShapeless;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.CraftingTableManager")
@Document(value="vanilla/api/managers/CraftingTableManager")
public class CTCraftingTableManager
implements IRecipeManager {
    @ZenCodeGlobals.Global(value="craftingTable")
    public static final CTCraftingTableManager INSTANCE = new CTCraftingTableManager();
    public static RecipeManager recipeManager;

    private CTCraftingTableManager() {
    }

    @ZenCodeType.Method
    public void addShaped(String recipeName, IItemStack output, IIngredient[][] ingredients, @ZenCodeType.Optional IRecipeManager.RecipeFunctionMatrix recipeFunction) {
        recipeName = this.validateRecipeName(recipeName);
        CraftTweakerAPI.apply(new ActionAddRecipe(this, (IRecipe<?>)new CTRecipeShaped(recipeName, output, ingredients, false, recipeFunction), "shaped"));
    }

    @ZenCodeType.Method
    public void addShapedMirrored(String recipeName, IItemStack output, IIngredient[][] ingredients, @ZenCodeType.Optional IRecipeManager.RecipeFunctionMatrix recipeFunction) {
        recipeName = this.validateRecipeName(recipeName);
        CraftTweakerAPI.apply(new ActionAddRecipe(this, (IRecipe<?>)new CTRecipeShaped(recipeName, output, ingredients, true, recipeFunction), "mirroring shaped"));
    }

    @ZenCodeType.Method
    public void addShapeless(String recipeName, IItemStack output, IIngredient[] ingredients, @ZenCodeType.Optional IRecipeManager.RecipeFunctionArray recipeFunction) {
        recipeName = this.validateRecipeName(recipeName);
        CraftTweakerAPI.apply(new ActionAddRecipe(this, (IRecipe<?>)new CTRecipeShapeless(recipeName, output, ingredients, recipeFunction), "shapeless"));
    }

    public IRecipeType<ICraftingRecipe> getRecipeType() {
        return IRecipeType.field_222149_a;
    }
}

